% Matlab i/o code examples 
% Piece of the Puzzle recon challenge, ISMRM Stockholm 2010
% E. Aboussouan, Barrow Neurological Inst., Phoenix AZ

% read data : 2000x4000x8 complex
fid = fopen('./POP_BHAR_09AUG06.dat');
dataPOP = zeros(2000*4000*8,1);
% read coil by coil to avoid running out of memory
for coil =1:8
    tmp =  fread(fid,2*2000*4000, 'float32');
    dataPOP(2000*4000*(coil-1)+1:2000*4000*coil)=complex(tmp(1:2:end), tmp(2:2:end));
end
fclose(fid);
clear tmp;
dataPOP= reshape(dataPOP,[2000,4000,8]);

% B1map:  80x80x55x8 complex 
fid = fopen('./POP_B1MAP80x80x55x8.dat');
B1MapPOP= fread(fid,inf, 'float32');
fclose(fid);
B1MapPOP= complex(B1MapPOP(1:2:end), B1MapPOP(2:2:end));
B1MapPOP= reshape(B1MapPOP,[80,80,55,8]);
 
% read coordinates: 3x2000x4000
fid = fopen('./POP_BHAR_09AUG06.crd');
POPCrds = fread(fid,inf, 'float32');
fclose(fid);
POPCrds = reshape(POPCrds,[3,2000,4000]);

% write data (example)
% first interleave real and odd values before writing
B1MapPOP = [real(B1MapPOP(:)), imag(B1MapPOP(:))]';
B1MapPOP = B1MapPOP(:);
% then write
fid = fopen('test.dat','wb')
fwrite(fid,B1MapPOP,'float32');
fclose(fid);